<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Country;
use App\Http\Controllers\CityController;
use App\Http\Controllers\StateController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\PartiesController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ItemsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();
// Super Admin Role
Route::middleware(['auth', 'user-role:superAdmin'])->group(function(){
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    //country
    Route::get('/country', [Country::class, 'index'])->name('country.index');
    Route::get('/country/add', [Country::class, 'addCountry'])->name('country.add');
    Route::post('/country/countryCreate', [Country::class, 'countryCreate'])->name('country.countryCreate');
    Route::get('/country/edit/{id}', [Country::class, 'editCountry'])->name('country.edit');
    Route::post('/country/updateCountry/{id}', [Country::class, 'updatecountry'])->name('country.updateCountry');

    //city
    Route::get('/city/{id}', [CityController::class, 'index'])->name('city.index');
    Route::get('/city/add/{id}', [CityController::class, 'addCity'])->name('city.add');
    Route::post('/city/cityCreate/{id}', [CityController::class, 'cityCreate'])->name('city.cityCreate');
    Route::get('/city/edit/{id}', [CityController::class, 'editCity'])->name('city.edit');
    Route::post('/city/updateCity/{id}', [CityController::class, 'updatecity'])->name('city.updateCity');

    
    //state
    Route::get('/state/{id}', [StateController::class, 'index'])->name('state.index');
    Route::get('/state/add/{id}', [StateController::class, 'addState'])->name('state.add');
    Route::post('/state/stateCreate/{id}', [StateController::class, 'stateCreate'])->name('state.stateCreate');
    Route::get('/state/edit/{id}', [StateController::class, 'editState'])->name('state.edit');
    Route::post('/state/updateState/{id}', [StateController::class, 'updatestate'])->name('state.updateState');

});

// Admin Role
Route::middleware(['auth', 'user-role:admin'])->group(function(){
    Route::get('/admin/home', [HomeController::class, 'adminIndex'])->name('admin.home');
    //Company
    Route::get('/company', [CompanyController::class, 'index'])->name('company.index');
    Route::get('/company/add', [CompanyController::class, 'addCompany'])->name('company.add');
    Route::post('/company/companyCreate', [CompanyController::class, 'companyCreate'])->name('company.companyCreate');
    Route::get('/company/edit/{id}', [CompanyController::class, 'editCompany'])->name('company.edit');
    Route::post('/company/updateCompany/{id}', [CompanyController::class, 'updateCompany'])->name('company.updateCompany');
});
// Company Role
Route::middleware(['auth', 'user-role:company'])->group(function(){
    Route::get('/company/home', [HomeController::class, 'adminIndex'])->name('company.home');
    //Company Bank Details
    Route::get('/bankDetails', [BankDetailsController::class, 'index'])->name('bankDetails.index');
    Route::get('/bankDetails/add', [BankDetailsController::class, 'add'])->name('bankDetails.add');
    Route::post('/bankDetails/bankCreate', [BankDetailsController::class, 'bankCreate'])->name('bankDetails.bankCreate');
    Route::get('/bankDetails/edit/{id}', [BankDetailsController::class, 'edit'])->name('bankDetails.edit');
    Route::post('/bankDetails/updateBank/{id}', [BankDetailsController::class, 'updateBank'])->name('bankDetails.updateBank');
    //Party
    Route::get('/party', [PartiesController::class, 'index'])->name('party.index');
    Route::get('/party/add', [PartiesController::class, 'addParty'])->name('party.add');
    Route::post('/party/partyCreate', [PartiesController::class, 'partyCreate'])->name('party.partyCreate');
    Route::get('/party/edit/{id}', [PartiesController::class, 'editParty'])->name('party.edit');
    Route::post('/party/updateParty/{id}', [PartiesController::class, 'updateParty'])->name('party.updateParty');
    Route::get('/partyDetails', [PartiesController::class, 'partyDetails'])->name('party.partyDetails');
    //User
    Route::get('/user', [UserController::class, 'index'])->name('user.index');
    Route::get('/user/add', [UserController::class, 'addUser'])->name('user.add');
    Route::post('/user/companyCreate', [UserController::class, 'userCreate'])->name('user.userCreate');
    Route::get('/user/edit/{id}', [UserController::class, 'editUser'])->name('user.edit');
    Route::post('/user/updateUser/{id}', [UserController::class, 'updateUser'])->name('user.updateUser');

//Item
Route::get('/item', [ItemsController::class, 'index'])->name('item.index');
Route::get('/item/add', [ItemsController::class, 'addItem'])->name('item.add');
Route::post('/item/itemCreate', [ItemsController::class, 'itemCreate'])->name('item.itemCreate');
Route::get('/item/edit/{id}', [ItemsController::class, 'editItem'])->name('item.edit');
Route::post('/item/updateItem/{id}', [ItemsController::class, 'updateItem'])->name('item.updateItem');
Route::post('/adjustStock', [ItemsController::class, 'adjustStock'])->name('adjustStock');
});

// Company Role
Route::middleware(['auth', 'user-role:user'])->group(function(){
    Route::get('/user/home', [HomeController::class, 'adminIndex'])->name('user.home');
});


Route::post('/ajaxOfBankDetails', [BankDetailsController::class, 'ajaxOfBankDetails'])->name('ajaxOfBankDetails');
Route::post('/ajaxNoOfState', [Country::class, 'ajaxNoOfState'])->name('ajaxNoOfState');
Route::post('/ajaxNoOfCity', [Country::class, 'ajaxNoOfCity'])->name('ajaxNoOfCity');
