@extends('dashboardLayout.main') @section('main-section') <div class="content container-fluid">
  <div class="row">
    <div class="col-sm-12">
      <div class="card">
        <div class="card-header card-buttons">
          <h5 class="card-title">Add Company</h5>
        </div>
        <div class="card-body card-buttons">
          <div class="row">
            <div class="col-sm-12">
                @if(Session::has('success'))
                    <div class="alert alert-success">{{Session::get('success')}}</div>
                @endif @if(Session::has('fail')) 
                    <div class="alert alert-danger">{{Session::get('fail')}}</div>
                @endif
            </div>
            <div class="col-sm">
              <form action="{{route('user.userCreate')}}" method="post">
                  @csrf
                <div class="form-row row">
                  <div class="col-md-3 mb-3">
                    <label for="validationCustom01">Name</label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}" placeholder="Name">
                    <span class="text-danger">@error('name') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="phone">Phone</label>
                    <input type="text" class="form-control" name="phone" id="phone" value="{{ old('phone') }}" placeholder="Phone">
                    <span class="text-danger">@error('phone') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Email</label>
                    <input type="email" class="form-control" name="email" id="email" value="{{ old('email') }}" placeholder="Email">
                    <span class="text-danger">@error('email') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Password</label>
                    <input type="password" class="form-control" name="password" id="password" value="{{ old('password') }}" placeholder="******">
                    <span class="text-danger">@error('password') {{$message}} @enderror </span>
                  </div>
                </div>
                <button class="btn btn-primary" type="submit">Submit</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div> @endsection