@extends('dashboardLayout.main')   
@section('main-section')
<div class="content container-fluid">
	<div class="page-header">
		<div class="content-page-header">
			<h5>Party</h5>
			<div class="list-btn">
				<ul class="filter-list">
					<li>
						<a class="btn btn-primary" href="{{ route('party.add') }}">
						<i class="fa fa-plus-circle me-2" aria-hidden="true"></i>Add Party </a>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			@if(Session::has('success'))
			<div class="alert alert-success">{{Session::get('success')}}</div>
			@endif
			@if(Session::has('fail'))
			<div class="alert alert-danger">{{Session::get('fail')}}</div>
			@endif
		</div>
		<div class="col-sm-12">
			<div class="card-table">
				<div class="card-body">
					<div class="table-responsive">
						<table class="table table-stripped table-hover ">
							<thead class="thead-light">
								<tr>
									<th>S No.</th>
									<th>Name</th>
									
									<th>Phone No.</th>
									<th>Party Type</th>
									<th>Balance</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								@foreach($party as $key=>$p)
								<tr>
									<td>{{$key+1}}</td>
									<td>{{$p->name}}</td>
			                        <td>{{$p->phone}}</td>
									<td>
									    <?php if($p->party_type == 0){
									        echo "Customer";
									    }else{
									        echo "Supplier";
									    } ?>
									</td>
									<td>0</td>
								<td class="d-flex align-items-center">
										<a href="{{route('party.edit', ['id' => $p->party_id])}}" class="btn btn-info">Edit</a>
									</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection