@extends('dashboardLayout.main')   
@section('main-section')
<div class="content container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-header card-buttons">
					<h5 class="card-title">Update Party</h5>
				</div>
				<div class="card-body card-buttons">
					<div class="row">
						<div class="col-sm-12">
							@if(Session::has('success'))
							<div class="alert alert-success">{{Session::get('success')}}</div>
							@endif @if(Session::has('fail')) 
							<div class="alert alert-danger">{{Session::get('fail')}}</div>
							@endif
						</div>
						<div class="col-sm">
							<form action="{{ route('party.updateParty', ['id' => $party->party_id]) }}" method="post">
								@csrf
								<div class="form-row row">
									<div class="col-md-4 mb-3">
										<label for="name"> Name <span class="text-danger">*</span></label>
										<input type="text" class="form-control" name="name" id="name" value="{{$party->name?$party->name:old('name')}}" placeholder="Name">
										<span class="text-danger">@error('name') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="email"> Email</label>
										<input type="text" class="form-control" name="email" id="email" value="{{$party->email?$party->email:old('email')}}" placeholder="Email">
										<span class="text-danger">@error('email') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="phone"> Phone</label>
										<input type="text" class="form-control" name="phone" id="phone" value="{{$party->phone?$party->phone:old('phone')}}" placeholder="0987654321">
										<span class="text-danger">@error('phone') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="address"> Address</label>
										<input type="text" class="form-control" name="address" id="address" value="{{$party->address?$party->address:old('address')}}" placeholder="Address">
										<span class="text-danger">@error('address') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="country_id">Country</label>
										<select name="country_id" class="form-select" id="country_id">
											<option value="">Select Country</option>
											@foreach($country as $key=>$c)
											<option value="{{$c->area_id}}">{{$c->name}}</option>
											@endforeach
										</select>
										<span class="text-danger">@error('country_id') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="email">State</label>
										<div id="show_state">
											<input type="text" class="form-control" name="" id="state_id" placeholder="State">
										</div>
										<span class="text-danger">@error('state_id') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="email">City</label>
										<div id="show_city">
											<input type="text" class="form-control" name="" id="city_id" placeholder="City">
										</div>
										<span class="text-danger">@error('city_id') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="gst"> GST</label>
										<input type="text" class="form-control" name="gst" id="gst" value="{{$party->gst?$party->gst:old('gst')}}" placeholder="GST No">
										<span class="text-danger">@error('gst') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="pancard"> Pancard</label>
										<input type="text" class="form-control" name="pancard" id="pancard" value="{{$party->pancard?$party->pancard:old('pancard')}}">
										<span class="text-danger">@error('pancard') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="credit_limit"> Credit Limit</label>
										<input type="text" class="form-control" name="credit_limit" id="credit_limit" value="{{$party->credit_limit?$party->credit_limit:old('credit_limit')}}">
										<span class="text-danger">@error('credit_limit') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="party_type"> Party Type</label>
										<select name="party_type" class="form-select">
											<option value="">Select Type</option>
											<option value="0">Customer</option>
											<option value="1">Supplier</option>
										</select>
										<span class="text-danger">@error('party_type') {{$message}} @enderror </span>
									</div>
								</div>
								<button class="btn btn-primary" type="submit">Submit</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection