@extends('dashboardLayout.main')   
@section('main-section')
<div class="content container-fluid">
	<div class="page-header">
		<div class="content-page-header">
			<h5>Items</h5>
			<div class="list-btn">
				<ul class="filter-list">
					<li>
						<a class="btn btn-primary" href="{{ route('item.add') }}">
						<i class="fa fa-plus-circle me-2" aria-hidden="true"></i>Add Items </a>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			@if(Session::has('success'))
			<div class="alert alert-success">{{Session::get('success')}}</div>
			@endif
			@if(Session::has('fail'))
			<div class="alert alert-danger">{{Session::get('fail')}}</div>
			@endif
		</div>
		<div class="col-sm-12">
			<div class="card-table">
				<div class="card-body">
					<div class="table-responsive">
						<table class="table table-stripped table-hover ">
							<thead class="thead-light">
								<tr>
									<th>S No.</th>
									<th>Item Name</th>
									<th>Item Code</th>
									<th>Stock QTY</th>
									<th>Stock Value</th>
									<th>Selling Price</th>
									<th>Purchase Price</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach($item as $key=>$i) { 
								    $masterDetails = DB::table('invoice_details')->selectRaw('SUM(credit) AS total_credit, SUM(debit) AS total_debit')->where('item_id', $i->item_id)->first();
								    $stock_qty = $masterDetails->total_credit-$masterDetails->total_debit;
								    $stock_value = $stock_qty*$i->cost_price;
								    
								?>
								
								<tr>
									<td>{{$key+1}}</td>
									<td>{{$i->name}}</td>
									<td>{{$i->item_code}}</td>
									<td>{{$stock_qty}}</td>
									<td>{{$stock_value}}</td>
									<td>{{$i->sale_price}}</td>
									<td>{{$i->cost_price}}</td>
									<td class="d-flex align-items-center">
										<a href="{{route('item.edit', ['id' => $i->item_id])}}" class="btn btn-info">Edit</a>
										<div class="button-list">
											<a class="btn btn-info btn-xs" data-bs-toggle="modal" data-bs-target="#signup-modal_<?php echo $key+1; ?>">Add Items</a>
											<div id="signup-modal_<?php echo $key+1; ?>" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
												<div class="modal-dialog">
													<div class="modal-content">
													    <div class="modal-header">
                                                            <h6 class="modal-title" id="standard-modalLabel">Adjust Stock Quantity</h6>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
														<div class="modal-body">
                                							<form action="{{ route('adjustStock') }}" class="px-3" method="post">
                                								@csrf
																<div class="mb-3">
																	<label for="username" class="form-label">Item Name</label>
																	<h6>{{$i->name}}</h6>
                                                        			<input class="form-check-input" type="hidden" name="item_id" id="item_id" value="{{$i->item_id}}">
																</div>
																<div class="mb-3">
                                                                	<label class="col-lg-3 col-form-label">Add or Reduce Stock</label>
                                                                	<div class="col-lg-9">
                                                                		<div class="form-check form-check-inline">
                                                                			<input class="form-check-input" type="radio" name="manage_stock" id="add_stock" value="credit" checked="">
                                                                			<label class="form-check-label" for="add_stock">
                                                                			Add (+)
                                                                			</label>
                                                                		</div>
                                                                		<div class="form-check form-check-inline">
                                                                			<input class="form-check-input" type="radio" name="manage_stock" id="reduce_stock" value="debit">
                                                                			<label class="form-check-label" for="reduce_stock">
                                                                			Reduce (-)
                                                                			</label>
                                                                		</div>
                                                                	</div>
																</div>
																<div class="mb-3">
																	<label for="password" class="form-label">Current Stock Level</label>
																	<h6>{{$stock_qty}} {{$i->unit_id}}</h6>
																</div>
																<div class="mb-3">
																	<label for="qty" class="form-label">Adjust Quantity <span class="text-danger">*</span></label>
																	<div class="input-group">
                                                                        <input type="number" class="form-control" aria-label="Quantity" name="quantity" required>
                                                                        <span class="input-group-text">{{$i->unit_id}}</span>
                                                                    </div>
																</div>
																<div class="mb-3">
																	<label for="remark" class="form-label">Remark (Optional)</label>
																	<textarea class="form-control" name="remark" id="remark"></textarea>
																</div>
    														</div>
    														<div class="modal-footer">
                                                                <button type="button" class="btn btn-light me-3" data-bs-dismiss="modal">Close</button>
                                                                <button type="submit" class="btn btn-primary">Save</button>
                                                            </div>
														</form>
													</div>
												</div>
											</div>
										</div>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection