@extends('dashboardLayout.main') @section('main-section') 
<div class="content container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-header card-buttons">
					<h5 class="card-title">Update item</h5>
				</div>
				<div class="card-body card-buttons">
					<div class="row">
						<div class="col-sm-12">
							@if(Session::has('success'))
							<div class="alert alert-success">{{Session::get('success')}}</div>
							@endif @if(Session::has('fail')) 
							<div class="alert alert-danger">{{Session::get('fail')}}</div>
							@endif
						</div>
						<div class="col-sm">
							<form action="{{ route('item.updateItem', ['id' => $item->item_id]) }}" method="post">
								@csrf
								<div class="form-row row">
									<div class="col-md-4 mb-3">
										<label for="name"> Name <span class="text-danger">*</span></label>
										<input type="text" class="form-control" name="name" id="name" value="{{$item->name?$item->name:old('name')}}" placeholder="Name">
										<span class="text-danger">@error('name') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="item_code"> Item Code</label>
										<input type="text" class="form-control" name="item_code" id="item_code" value="{{$item->item_code?$item->item_code:old('item_code')}}" placeholder="item_code">
										<span class="text-danger">@error('item_code') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="cost_price"> Cost Price</label>
										<input type="text" class="form-control" name="cost_price" id="cost_price" value="{{$item->cost_price?$item->cost_price:old('cost_price')}}" placeholder="cost_price">
										<span class="text-danger">@error('cost_price') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="selling_price"> Selling price</label>
										<input type="text" class="form-control" name="sale_price" id="sale_price" value="{{$item->sale_price?$item->sale_price:old('sale_price')}}" placeholder="sale_price">
										<span class="text-danger">@error('selling_price') {{$message}} @enderror </span>
									</div>
								<div class="col-md-4 mb-3">
										<label for="description"> Description</label>
										<input type="text" class="form-control" name="description" id="description" value="{{$item->description?$item->description:old('description')}}" placeholder="description">
										<span class="text-danger">@error('description') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="opening_stock_value"> Opening Stock Value</label>
										<input type="text" class="form-control" name="opening_stock_value" id="opening_stock_value" value="{{$item->opening_stock_value?$item->opening_stock_value:old('opening_stock_value')}}" placeholder="opening_stock_value">
										<span class="text-danger">@error('opening_stock_value') {{$message}} @enderror </span>
									</div>
						           <div class="col-md-4 mb-3">
										<label for="unit_id"> Unit</label>
										<select name="unit_id" class="form-select">
											<option value="">Select Type</option>
											<option value="LAD">LADI(LAD)</option>
											<option value="PET">PETI(PET)</option>
											<option value="JAR">JARS(JAR)</option>
											<option value="HEGAR">HANGER(HEGAR)</option>
											<option value=" POUCH(POCH)"> POUCH(POCH) </option>
											<option value=" BORA(BOR)">BORA(BOR)</option>
											<option value=" COIL(COIL)"> COIL(COIL) </option>
											<option value=" FEET(FT)"> FEET(FT)</option>
											<option value=" INCHES(IN)"> INCHES(IN)</option>
											<option value=" PORTION(PRT)"> PORTION(PRT)</option>
											<option value=" CASE(CASE)"> CASE(CASE)</option>
											<option value=" EACH(EACH)"> EACH(EACH)</option>
											<option value="CAPSULES(CPS)">CAPSULES(CPS)</option>
											<option value=" PADS(PADS)"> PADS(PADS)</option>
											<option value=" REEL(REEL)"> REEL(REEL)</option>
											<option value=" BLISTER(BLISTER) "> BLISTER(BLISTER) </option>
											<option value=" PAD(PAD)"> PAD(PAD)</option>
											<option value=" PIECES(PCS)"> PIECES(PCS)</option>
											<option value=" PAIRS(PRS)"> PAIRS(PRS)</option>
											<option value="QUINTAL(QTL)">QUINTAL(QTL)</option>
											<option value=" ROLLS(ROL)"> ROLLS(ROL)</option>
											<option value=" SETS(SET)"> SETS(SET)</option>
											<option value="SQUARE FEET(SQF) ">SQUARE FEET(SQF) </option>
											<option value="SQUARE METERS(SQM)">SQUARE METERS(SQM)</option>
											<option value="SQUARE YARDS(SQY)">SQUARE YARDS(SQY)</option>
											<option value="TABLETS(TBS)">TABLETS(TBS)</option>
											<option value="TEN GROSS(TGM)">TEN GROSS(TGM)</option>
											<option value=" THOUSANDS(THD)"> THOUSANDS(THD)</option>
											<option value="TONNES(TON)">TONNES(TON)</option>
											<option value="TUBES(TUB)">TUBES(TUB)</option>
											<option value="US GALLONS(UGS)">US GALLONS(UGS)</option>
											<option value="UNITS(UNT)">UNITS(UNT)</option>
											<option value="YARDS(YDS)">YARDS(YDS)</option>
											<option value="OTHERS(OTH)">OTHERS(OTH)</option>
											<option value="HOURS(HRS)">HOURS(HRS)</option>
									    	<option value="MINUTES(MINS)">MINUTES(MINS)</option>
											<option value="LITRE(LTR)">LITRE(LTR)</option>
											<option value="METRIC TON(MTON) ">METRIC TON(MTON) </option>
											<option value="MILLIGRAM(MLG)">MILLIGRAM(MLG)</option>
											<option value=" BUCKETS(BCK) "> BUCKETS(BCK) </option>
											<option value="GLASSES(GLS)">GLASSES(GLS)</option>
											<option value="PLATES(PLT)">PLATES(PLT)</option>
											<option value="CARATS(CTS)">CARATS(CTS)</option>
										    <option value="STRIPS(STRP)">STRIPS(STRP)</option>
											<option value="CARATS(CTS)">CARATS(CTS)</option>
											<option value="CUBIC FOOT(CFT)">CUBIC FOOT(CFT)</option>
											<option value=" VIALS(VIAL)"> VIALS(VIAL)</option>
											<option value="BAGS(BAG)">BAGS(BAG)</option>
											<option value="BALE(BAL)">BALE(BAL)</option>
											<option value="BUNDLES(BDL)">BUNDLES(BDL)</option>
											<option value="BUCKLES(BKL)">BUCKLES(BKL)</option>
											<option value="BILLIONS OF UNITS(BOU)">BILLIONS OF UNITS(BOU)</option>
											<option value="BOX(BOX)">BOX(BOX)</option>
											<option value="BOTTLES(BTL)">BOTTLES(BTL)</option>
											<option value="BUNCHES(BUN)">BUNCHES(BUN)</option>
											<option value="CANS(CAN)">CANS(CAN)</option>
											<option value="CUBIC CENTIMETER(CCM)">CUBIC CENTIMETER(CCM)</option>
											<option value="CENTIMETER(CMS)">CENTIMETER(CMS)</option>
											<option value="CARTONS(CTN)">CARTONS(CTN)</option>
											<option value="DOZEN(DOZ)">DOZEN(DOZ)</option>
											<option value="DRUM(DRM)">DRUM(DRM)</option>
											<option value="GREAT GROSS(GGR)">GREAT GROSS(GGR)</option>
											<option value="GRAMS(GMS)">GRAMS(GMS)</option>
											<option value="GROSS(GRS)">GROSS(GRS)</option>
											<option value="GROSS YARDS(GYD)">GROSS YARDS(GYD)</option>
											<option value="KILOGRAMS(KGS)">KILOGRAMS(KGS)</option>
											<option value=" KILOLITER(KLR)"> KILOLITER(KLR)</option>
											<option value="KILOMETRE(KME)">KILOMETRE(KME)</option>
											<option value="MILLILITRE(MLT)">MILLILITRE(MLT)</option>
											<option value="METERS(MTR)">METERS(MTR)</option>
											<option value="NUMBERS(NOS)">NUMBERS(NOS)</option>
											<option value=" PACKS(PAC)"> PACKS(PAC)</option>
											<option value="CENTS(CNT)">CENTS(CNT)</option>
											<option value="RUNNING FOOT(RFT)">RUNNING FOOT(RFT)</option>
											<option value="RIM(RIM)">RIM(RIM)</option>
											<option value="TIN(TIN)">TIN(TIN)</option>
											<option value=" CHUDI(CHUDI)"> CHUDI(CHUDI)</option>
											<option value="PATTA(PATTA)">PATTA(PATTA)</option>
											<option value="KIT(KIT)">KIT(KIT)</option>
											<option value="CUBIC FEET(CUFT)">CUBIC FEET(CUFT)</option>
								        	<option value="RUNNING METER(RMT)">RUNNING METER(RMT)</option>
									    	<option value="TRAYS(TRY)">TRAYS(TRY)</option>
											<option value="AMPOULE(AMP)">AMPOULE(AMP)</option>
											<option value="PAIR(PAIR)">PAIR(PAIR)</option>
											<option value=" AANA(ANA)">AANA(ANA)</option>
											<option value="CUBIC FEET PER MINUTE(CFM)">CUBIC FEET PER MINUTE(CFM)</option>
										    <option value="YEARS(YRS)">YEARS(YRS)</option>
											<option value="MONTH (UOM)">MONTH (UOM)</option>
											<option value="MAN-DAYS(MAN-DAY)">MAN-DAYS(MAN-DAY) </option>	
											<option value="NIGHTS(NIGHT)">NIGHTS(NIGHT)</option>
											<option value="DAYS(DAY)">DAYS(DAY)</option>
											<option value="SQUARE INCHES(SQIN)">SQUARE INCHES(SQIN)</option>
											<option value="WEEKS(WEEK)">WEEKS(WEEK)</option>
											<option value="PERSONS(PERSON)">PERSONS(PERSON)</option>
											<option value="LOT(LOT)">LOT(LOT)</option>
											<option value="SACHET(SAC)">SACHET(SAC)</option>
											<option value="REAM(REAM)">REAM(REAM)</option>
											<option value="BRASS(BRASS)">BRASS(BRASS)</option>
											<option value="NONE(NONE)">NONE(NONE)</option>
											<option value="COPY(COPY)">COPY(COPY)</option>
											<option value="TICKET(TKT)">TICKET(TKT)</option>
											<option value="KILOWATT(KW)">KILOWATT(KW)</option>
											<option value="WATT(W)">WATT(W)</option>
											<option value=" MBPS(MBPS)"> MBPS(MBPS)</option>
											<option value=" ACRE(AC) "> ACRE(AC) </option>
											<option value="HECTARE(HA)">HECTARE(HA)</option>
											<option value="BOLUS(BOLUS)">BOLUS(BOLUS)</option>
											<option value="AAAAAAAAAAA(G NEX)">AAAAAAAAAAA(G NEX)</option>
											<option value="KILOVOLT-AMP(KVA) ">KILOVOLT-AMP(KVA) </option>
											<option value="POINT(PT)">POINT(PT) </option>
											<option value=" MARK(MRK)"> MARK(MRK)</option>
											<option value="STONE(STONE)">STONE(STONE)</option>
											<option value="BRICK(BRICK )">BRICK(BRICK )</option>
											<option value="PACKETS(PKT)">PACKETS(PKT)</option>
											<option value="BARNI(BAR)">BARNI(BAR)</option>
											<option value="SHEET(SHEET)">SHEET(SHEET)</option>
											<option value="ITEM ID(ITEM ID)">ITEM ID(ITEM ID)</option>
											<option value=" MILLIMETER(MM) "> MILLIMETER(MM) </option>
											<option value=" CONTAINER(CONT)">CONTAINER(CONT)</option>
											<option value="SQUARE CENTIMETERS(SQCM)">SQUARE CENTIMETERS(SQCM)</option>
											<option value="INSERTION(INS)">INSERTION(INS)</option>
											<option value=" LENGTH(LENG)"> LENGTH(LENG)</option>
											<option value="GEL(GEL)">GEL(GEL)</option>
											<option value="SYRUP(SYRP)">SYRUP(SYRP)</option>
											<option value="SESSION(SSN) ">SESSION(SSN) </option>
															
										</select>
										<span class="text-danger">@error('unit_id') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="gst"> GST <span class="text-danger">*</span></label>
										<input type="text" class="form-control" name="gst" id="gst" value="{{$item->gst?$item->gst:old('gst')}}">
										<span class="text-danger">@error('gst') {{$message}} @enderror </span>
									</div>
									<div class="col-md-4 mb-3">
										<label for="hsnCode"> HSN Code</label>
										<input type="text" class="form-control" name="hsnCode" id="hsnCode" value="{{$item->hsnCode?$item->hsnCode:old('hsnCode')}}">
										<span class="text-danger">@error('hsnCode') {{$message}} @enderror </span>
									</div>
							    </div>
								<button class="btn btn-info" type="submit">Submit</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection