@extends('dashboardLayout.main')   
@section('main-section') 
<div class="content container-fluid">
      <div class="page-header">
        <div class="content-page-header">
          <h5>Company</h5>
          <div class="list-btn">
            <ul class="filter-list">
              <li>
            <a class="btn btn-primary" href="{{ route('company.add') }}">
                  <i class="fa fa-plus-circle me-2" aria-hidden="true"></i>Add company </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
            @if(Session::has('success'))
                <div class="alert alert-success">{{Session::get('success')}}</div>
            @endif
            @if(Session::has('fail'))
                <div class="alert alert-danger">{{Session::get('fail')}}</div>
            @endif
        </div>
        <div class="col-sm-12">
          <div class="card-table">
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-stripped table-hover ">
                  <thead class="thead-light">
                    <tr>
                      <th>S No.</th>
                      <th>Company Name</th>
                      <th>Company Owner Name</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Starting Year</th>
                      <th>Ending Year</th>
                      <th class="text-end">Action</th>
                    </tr>
                  </thead>
                  <tbody>
                      @foreach($company as $key=>$c)
                        <tr>
                          <td>{{$key+1}}</td>
                          <td>{{$c->name}}</td>
                          <td>{{$c->contact_person_name}}</td>
                          <td>{{$c->email}}</td>
                          <td>{{$c->phone}}</td>
                          <td>{{$c->starting_year}}</td>
                          <td>{{$c->ending_year}}</td>
                          <td class="d-flex align-items-center">
                              <a href="{{route('company.edit', ['id' => $c->company_id])}}" class="btn btn-info">Edit</a>
                          </td>
                        </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
      
@endsection