@extends('dashboardLayout.main')   
@section('main-section')  <div class="content container-fluid">
  <div class="row">
    <div class="col-sm-12">
      <div class="card">
        <div class="card-header card-buttons">
          <h5 class="card-title">Edit Company</h5>
        </div>
        <div class="card-body card-buttons">
          <div class="row">
            <div class="col-sm-12">
                @if(Session::has('success'))
                    <div class="alert alert-success">{{Session::get('success')}}</div>
                @endif @if(Session::has('fail')) 
                    <div class="alert alert-danger">{{Session::get('fail')}}</div>
                @endif
            </div>
            <div class="col-sm">
               <form action="{{ route('company.updateCompany', ['id' => $company->company_id]) }}" method="post">
                  @csrf
                <div class="form-row row">
                  <div class="col-md-3 mb-3">
                    <label for="validationCustom01">Company Name</label>
                    <input type="text" class="form-control" name="name" id="name" value="{{$company->name?$company->name:old('name')}}" placeholder="Company Name">
                    <span class="text-danger">@error('name') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="contact_person_name">Contact Owner Name</label>
                    <input type="text" class="form-control" name="contact_person_name" id="contact_person_name" value="{{$company->contact_person_name?$company->contact_person_name:old('contact_person_name')}}" placeholder="Contact Owner Name">
                    <span class="text-danger">@error('contact_person_name') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="phone">Phone</label>
                    <input type="text" class="form-control" name="phone" id="phone" value="{{$company->phone?$company->phone:old('phone')}}" placeholder="Phone">
                    <span class="text-danger">@error('phone') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Email</label>
                    <input type="email" class="form-control" name="email" id="email" value="{{$company->email?$company->email:old('email')}}" placeholder="Email">
                    <span class="text-danger">@error('email') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Address</label>
                    <input type="text" class="form-control" name="address" id="address" value="{{$company->address?$company->address:old('address')}}" placeholder="Address">
                    <span class="text-danger">@error('address') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="country_id">Country</label>
                    <select name="country_id" class="form-select" id="country_id">
                      <option value="">Select Country</option>
                      @foreach($country as $key=>$c)
                        <option value="{{$c->area_id}}" <?php if($c->area_id == $company->country_id){ echo 'selected'; } ?>>{{$c->name}}</option>
                      @endforeach
                    </select>
                    <span class="text-danger">@error('country_id') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">State</label>
                    <div id="show_state">
                      <?php if(!empty($company->state_id)){ ?>
                        <select name="state_id" class="form-select" id="state_id">
                          <option value="">Select State</option>
                          @foreach($state as $key=>$s)
                            <option value="{{$s->area_id}}" <?php if($s->area_id == $company->state_id){ echo 'selected'; } ?>>{{$s->name}}</option>
                          @endforeach
                        </select>
                        <?php }else{ ?>
                          <input type="text" class="form-control" name="" id="state_id" placeholder="State">
                        <?php } ?>
                    </div>
                    <span class="text-danger">@error('state_id') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">City</label>
                    <div id="show_city">
                      <?php if(!empty($company->state_id)){ ?>
                        <select name="city_id" class="form-select" id="city_id">
                          <option value="">Select City</option>
                          @foreach($city as $key=>$c)
                            <option value="{{$c->area_id}}" <?php if($c->area_id == $company->city_id){ echo 'selected'; } ?>>{{$c->name}}</option>
                          @endforeach
                        </select>
                        <?php }else{ ?>
                          <input type="text" class="form-control" name="" id="city_id" placeholder="City">
                        <?php } ?>
                        
                    </div>
                    <span class="text-danger">@error('city_id') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Zip Code</label>
                    <input type="text" class="form-control" name="zip_code" id="zip_code" value="{{$company->zip_code?$company->zip_code:old('zip_code')}}" placeholder="Zip Code">
                    <span class="text-danger">@error('zip_code') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">GST No</label>
                    <input type="text" class="form-control" name="gstNo" id="gstNo" value="{{$company->gstNo?$company->gstNo:old('gstNo')}}" placeholder="GST NO">
                    <span class="text-danger">@error('gstNo') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Pancard No.</label>
                    <input type="text" class="form-control" name="pancard" id="pancard" value="{{$company->pancard?$company->pancard:old('pancard')}}" placeholder="Pancard No.">
                    <span class="text-danger">@error('pancard') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Starting Financial Year</label>
                    <input type="date" class="form-control" name="starting_year" id="starting_year" value="{{$company->starting_year?$company->starting_year:old('starting_year')}}" placeholder="Starting Financial Year">
                    <span class="text-danger">@error('starting_year') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Ending Financial Year</label>
                    <input type="date" class="form-control" name="ending_year" id="ending_year" value="{{$company->ending_year?$company->ending_year:old('ending_year')}}" placeholder="Ending Financial Year">
                    <span class="text-danger">@error('ending_year') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="logo">Company Logo</label>
                    <input type="file" class="form-control" name="logo" id="logo" value="{{ old('logo') }}" placeholder="Company Logo">
                    <span class="text-danger">@error('ending_year') {{$message}} @enderror </span>
                  </div>
                </div>
                <button class="btn btn-primary" type="submit">Submit</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div> @endsection