@extends('dashboardLayout.main')   
@section('main-section')  <div class="content container-fluid">
  <div class="row">
    <div class="col-sm-12">
      <div class="card">
        <div class="card-header card-buttons">
          <h5 class="card-title">Add Company</h5>
        </div>
        <div class="card-body card-buttons">
          <div class="row">
            <div class="col-sm-12">
                @if(Session::has('success'))
                    <div class="alert alert-success">{{Session::get('success')}}</div>
                @endif @if(Session::has('fail')) 
                    <div class="alert alert-danger">{{Session::get('fail')}}</div>
                @endif
            </div>
            <div class="col-sm">
              <form action="{{route('company.companyCreate')}}" method="post" enctype="multipart/form-data">
                  @csrf
                <div class="form-row row">
                  <div class="col-md-3 mb-3">
                    <label for="validationCustom01">Company Name</label>
                    <input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}" placeholder="Company Name">
                    <span class="text-danger">@error('name') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="contact_person_name">Contact Owner Name</label>
                    <input type="text" class="form-control" name="contact_person_name" id="contact_person_name" value="{{ old('contact_person_name') }}" placeholder="Contact Owner Name">
                    <span class="text-danger">@error('contact_person_name') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="phone">Phone</label>
                    <input type="text" class="form-control" name="phone" id="phone" value="{{ old('phone') }}" placeholder="Phone">
                    <span class="text-danger">@error('phone') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Email</label>
                    <input type="email" class="form-control" name="email" id="email" value="{{ old('email') }}" placeholder="Email">
                    <span class="text-danger">@error('email') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Address</label>
                    <input type="text" class="form-control" name="address" id="address" value="{{ old('address') }}" placeholder="Address">
                    <span class="text-danger">@error('address') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="country_id">Country</label>
                    <select name="country_id" class="form-select" id="country_id">
					    <option value="">Select Country</option>
                        @foreach($country as $key=>$c)
					        <option value="{{$c->area_id}}">{{$c->name}}</option>
                        @endforeach
					</select>
                    <span class="text-danger">@error('country_id') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">State</label>
                    <div id="show_state">
                        <input type="text" class="form-control" name="" id="state_id" placeholder="State">
                    </div>
                    <span class="text-danger">@error('state_id') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">City</label>
                    <div id="show_city">
                        <input type="text" class="form-control" name="" id="city_id" placeholder="City">
                    </div>
                    <span class="text-danger">@error('city_id') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Zip Code</label>
                    <input type="text" class="form-control" name="zip_code" id="zip_code" value="{{ old('zip_code') }}" placeholder="Zip Code">
                    <span class="text-danger">@error('zip_code') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">GST No</label>
                    <input type="text" class="form-control" name="gstNo" id="gstNo" value="{{ old('gstNo') }}" placeholder="GST NO">
                    <span class="text-danger">@error('gstNo') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Pancard No.</label>
                    <input type="text" class="form-control" name="pancard" id="pancard" value="{{ old('pancard') }}" placeholder="Pancard No.">
                    <span class="text-danger">@error('pancard') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Starting Financial Year</label>
                    <input type="date" class="form-control" name="starting_year" id="starting_year" value="{{ old('pancard') }}" placeholder="Starting Financial Year">
                    <span class="text-danger">@error('starting_year') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="email">Ending Financial Year</label>
                    <input type="date" class="form-control" name="ending_year" id="ending_year" value="{{ old('ending_year') }}" placeholder="Ending Financial Year">
                    <span class="text-danger">@error('ending_year') {{$message}} @enderror </span>
                  </div>
                  <div class="col-md-3 mb-3">
                    <label for="logo">Company Logo</label>
                    <input type="file" class="form-control" name="logo" id="logo" value="{{ old('logo') }}" placeholder="Company Logo">
                    <span class="text-danger">@error('ending_year') {{$message}} @enderror </span>
                  </div>
                </div>
                <button class="btn btn-primary" type="submit">Submit</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div> @endsection