@extends('dashboardLayout.main')   
@section('main-section') 
<div class="content container-fluid">
      <div class="page-header">
        <div class="content-page-header">
          <h5>city</h5>
          <div class="list-btn">
            <ul class="filter-list">
              <li>
                <a class="btn btn-primary" href="{{ route('city.add', ['id' => $stateId]) }}">
                  <i class="fa fa-plus-circle me-2" aria-hidden="true"></i>Add city </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
            @if(Session::has('success'))
                <div class="alert alert-success">{{Session::get('success')}}</div>
            @endif
            @if(Session::has('fail'))
                <div class="alert alert-danger">{{Session::get('fail')}}</div>
            @endif
        </div>
        <div class="col-sm-12">
          <div class="card-table">
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-stripped table-hover ">
                  <thead class="thead-light">
                    <tr>
                      <th>#</th>
                      <th>Name</th>
                      <th class="text-end">Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach($city as $key=>$c)
                        <tr>
                          <td>{{$key+1}}</td>
                          <td>{{$c->name}}</td>
                          <td class="d-flex align-items-center">
                              <a href="{{route('city.edit', ['id' => $c->area_id])}}" class="btn btn-info">Edit</a>
                          </td>
                        </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
      
@endsection