@extends('dashboardLayout.main')   
@section('main-section') 
<div class="content container-fluid">
	<div class="page-header">
		<div class="content-page-header">
			<h5>Bank Details</h5>
			<div class="list-btn">
				<ul class="filter-list">
					<li>
						<a class="btn btn-primary" href="{{ route('bankDetails.add') }}">
						<i class="fa fa-plus-circle me-2" aria-hidden="true"></i>Add Bank Details </a>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			@if(Session::has('success'))
			<div class="alert alert-success">{{Session::get('success')}}</div>
			@endif
			@if(Session::has('fail'))
			<div class="alert alert-danger">{{Session::get('fail')}}</div>
			@endif
		</div>
		<div class="col-sm-12">
			<div class="card-table">
				<div class="card-body">
					<div class="table-responsive">
						<table class="table table-stripped table-hover ">
							<thead class="thead-light">
								<tr>
									<th>S No.</th>
									<th>Company Name</th>
									<th>Name</th>
									<th>Account No</th>
									<th>IFSC Code</th>
									<th>Bank Branch</th>
									<th>Account Holder Name</th>
									<th>UPI ID</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach($bankDetails as $key=>$bd) { ?>
								<tr>
									<td>{{$key+1}}</td>
									<td>{{$bd->user->name}}</td>
									<td>{{$bd->name}}</td>
									<td>{{$bd->account_no}}</td>
									<td>{{$bd->ifsc_code}}</td>
									<td>{{$bd->bank_branch}}</td>
									<td>{{$bd->account_holder_name}}</td>
									<td>{{$bd->upi_id}}</td>
									<td class="d-flex align-items-center">
										<a href="{{route('bankDetails.edit', ['id' => $bd->bank_id])}}" class="btn btn-info">Edit</a>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection