@extends('dashboardLayout.main')   
@section('main-section') 
<div class="content container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-header card-buttons">
					<h5 class="card-title">Add Bank Details</h5>
				</div>
				<div class="card-body card-buttons">
					<div class="row">
						<div class="col-sm-12">
							@if(Session::has('success'))
							<div class="alert alert-success">{{Session::get('success')}}</div>
							@endif @if(Session::has('fail')) 
							<div class="alert alert-danger">{{Session::get('fail')}}</div>
							@endif
						</div>
						<div class="col-sm">
							<form action="{{ route('bankDetails.bankCreate') }}" method="post">
								@csrf
							    <div class="form-row row">
									<div class="col-md-4 mb-3">
										<label for="account_type"> Account Type <span class="text-danger">*</span></label>
										<select name="account_type" class="js-example-basic-single"  id="account_type" >
											<option value="">Select Account Type</option>
											<option value="1">Current Account</option>
											<option value="2">Saving Account</option>
											<option value="3">UPI ID</option>
										</select>
										<span class="text-danger">@error('account_type') {{$message}} @enderror </span>
									</div>
								</div>
								<div class="bank_details_box">
								    <div class="form-row row bank_details_box">
    									<div class="col-md-4 mb-3">
    										<label for="name"> Bank Name <span class="text-danger">*</span></label>
    										<input type="text" class="form-control" name="name" id="name" value="{{ old('name') }}"  >
    										<span class="text-danger">@error('name') {{$message}} @enderror </span>
    									</div>
    									<div class="col-md-4 mb-3">
    										<label for="account_no"> Account No <span class="text-danger">*</span></label>
    										<input type="number" class="form-control" name="account_no" id="account_no" value="{{ old('account_no') }}" >
    										<span class="text-danger">@error('account_no') {{$message}} @enderror </span>
    									</div>
    									<div class="col-md-4 mb-3">
    										<label for="ifsc_code"> IFSC Code <span class="text-danger">*</span></label>
    										<input type="text" class="form-control" name="ifsc_code" id="ifsc_code" value="{{ old('ifsc_code') }}" >
    										<span class="text-danger">@error('ifsc_code') {{$message}} @enderror </span>
    									</div>
    									<div class="col-md-4 mb-3">
    										<label for="bank_branch"> Bank Branch <span class="text-danger">*</span></label>
    										<input type="text" class="form-control" name="bank_branch" id="bank_branch" value="{{ old('bank_branch') }}" >
    										<span class="text-danger">@error('bank_branch') {{$message}} @enderror </span>
    									</div>
    									<div class="col-md-4 mb-3">
    										<label for="account_holder_name"> Account Holder Name <span class="text-danger">*</span></label>
    										<input type="text" class="form-control" name="account_holder_name" id="account_holder_name" value="{{ old('account_holder_name') }}">
    										<span class="text-danger">@error('account_holder_name') {{$message}} @enderror </span>
    									</div>
									</div>
								</div>
							    <div class="form-row row upi_box" style="display:none;">
									<div class="col-md-4 mb-3">
										<label for="upi_id"> UPI ID</label>
										<input type="text" class="form-control" name="upi_id" id="upi_id" value="{{ old('upi_id') }}">
										<span class="text-danger">@error('upi_id') {{$message}} @enderror </span>
									</div>
    							</div>
								<button class="btn btn-primary" type="submit">Submit</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection