@extends('layouts.app')

@section('content')
<div class="login-wrapper">
        <div class="container">
          <img class="img-fluid logo-dark mb-2" src="{{url('/')}}/assets/img/logo2.png" alt="Logo">
          <div class="loginbox">
            <div class="login-right">
              <div class="login-right-wrap">
                <h1>Login</h1>
                <p class="account-subtitle">Access to our dashboard</p>
		        @if(Session::has('success'))
                    <div class="alert alert-success">{{Session::get('success')}}</div>
                @endif
                @if(Session::has('fail'))
                    <div class="alert alert-danger">{{Session::get('fail')}}</div>
                @endif
                <form action="{{ route('login') }}" method="post">
                    @csrf
                  <div class="form-group">
                    <label class="form-control-label">Email Address</label>
                    <input type="email" id="email" class="form-control  @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                    <span class="text-danger">@error('email') {{$message}} @enderror </span>
                  </div>
                  <div class="form-group">
                    <label class="form-control-label">Password</label>
                    <div class="pass-group">
                      <input type="password" name="password" id="password" class="form-control pass-input  @error('password') is-invalid @enderror" required autocomplete="current-password">
                      <!-- <span class="fas fa-eye toggle-password"></span> -->
                      <span class="text-danger">@error('password') {{$message}} @enderror </span>
                    </div>
                  </div>
                  <div class="form-group">
                    <div class="row">
                      <div class="col-6 text-end">
                      @if (Route::has('password.request'))
                        <a class="forgot-link" href="{{ route('password.request') }}">
                            {{ __('Forgot Your Password?') }}
                        </a>
                      @endif
                      </div>
                    </div>
                  </div>
                  <button class="btn btn-lg btn-block btn-primary w-100" type="submit">Login</button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
@endsection
