<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('company_assets_setting', function (Blueprint $table) {
            $table->id('company_assets_setting_id');
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('sale')->nullable();
            $table->unsignedBigInteger('purchase')->nullable();
            $table->unsignedBigInteger('direct_expense')->nullable();
            $table->unsignedBigInteger('indirect_expense')->nullable();
            $table->unsignedBigInteger('direct_income')->nullable();
            $table->unsignedBigInteger('indirect_income')->nullable();
            $table->unsignedBigInteger('capital_account')->nullable();
            $table->unsignedBigInteger('current_liabilities')->nullable();
            $table->unsignedBigInteger('loan_liabilities')->nullable();
            $table->unsignedBigInteger('fixed_assets')->nullable();
            $table->unsignedBigInteger('current_assets')->nullable();
            $table->unsignedBigInteger('cgst')->nullable();
            $table->unsignedBigInteger('sgst')->nullable();
            $table->unsignedBigInteger('igst')->nullable();
            $table->unsignedBigInteger('tcs')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_assets_setting');
    }
};
