<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_details', function (Blueprint $table) {
            $table->id('bank_id');
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('account_type')->nullable();
            $table->string('name', 255)->nullable();
            $table->string('account_no', 255)->nullable();
            $table->string('ifsc_code', 255)->nullable();
            $table->string('bank_branch', 255)->nullable();
            $table->string('account_holder_name', 255)->nullable();
            $table->string('upi_id', 255)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_details');
    }
};
