<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_details', function (Blueprint $table) {
            $table->id('invoice_details_id');
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('type_of_invoice');
            $table->unsignedBigInteger('invoice_master_id');
            $table->unsignedBigInteger('item_id');
            $table->string('credit', 255);
            $table->string('debit', 255);
            $table->string('per_item_price', 255);
            $table->string('total_price', 255);
            $table->string('gst', 255);
            $table->unsignedBigInteger('tax_type');
            $table->string('total_with_gst', 255);
            $table->timestamp('date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_details');
    }
};
