<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('journal_details', function (Blueprint $table) {
            $table->id('journal_details_id');
            $table->unsignedBigInteger('company_id');
            $table->string('journal_no', 255);
            $table->unsignedBigInteger('journal_master_id');
            $table->unsignedBigInteger('ac_chart_id');
            $table->unsignedBigInteger('type_of_entry');
            $table->string('debit', 255);
            $table->string('credit', 255);
            $table->string('narration', 255);
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('journal_details');
    }
};
