<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('item', function (Blueprint $table) {
            $table->id('item_id');
            $table->unsignedBigInteger('company_id')->nullable();
            $table->string('name', 255)->nullable();
            $table->string('item_code', 255)->nullable();
            $table->string('cost_price', 255)->nullable();
            $table->string('sale_price', 255)->nullable();
            $table->string('description', 255)->nullable();
            $table->string('opening_stock_value', 255)->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->unsignedBigInteger('gst')->nullable();
            $table->unsignedBigInteger('hsnCode')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item');
    }
};
