<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('parties', function (Blueprint $table) {
            $table->bigIncrements('party_id');
            $table->unsignedBigInteger('ac_chart_id')->nullable();
            $table->string('name', 255)->nullable();
            $table->string('email', 255)->nullable();
            $table->string('phone', 255)->nullable();
            $table->string('address', 255)->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->unsignedBigInteger('state_id')->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->string('gst', 255)->nullable();
            $table->string('shipping_address', 255)->nullable();
            $table->unsignedBigInteger('shipping_city_id')->nullable();
            $table->unsignedBigInteger('shipping_state_id')->nullable();
            $table->unsignedBigInteger('shipping_country_id')->nullable();
            $table->string('pancard', 255)->nullable();
            $table->string('credit_limit', 255)->nullable();
            $table->string('opening_balance', 255)->nullable();
            $table->unsignedBigInteger('party_type')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->string('createdBy', 255)->nullable();
            $table->string('modifiedBy', 255)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('parties');
    }
};
