<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AreaModel;
use App\Models\UserTypeModel;
use App\Models\CompanyModel;
use App\Models\User;
use Hash;

class UserController extends Controller
{
    
    public function index(Request $req){
        $company_id = $req->session()->get('company_id');
        $user = User::where(array('role' => 3, 'company_id' => $company_id))->get();
        $data = compact('user');
        return view('user/index')->with($data);
    }
    
    public function addUser(Request $req){
        $country = AreaModel::whereNull('parent_id')->get();
        $data = compact('country');
        return view('user/add')->with($data);
    }
     
    public function userCreate(Request $req){
        $company_id = $req->session()->get('company_id');
        $req->validate(
            [
                'name' => 'required',
                'email' => 'required|email|unique:users,email',
                'password' => 'required',
            ]
        ); 
        User::create([
            'company_id' => $company_id,
            'name' => $req['name'],
            'email' => $req['email'],
            'phone' => $req['phone'],
            'password' => Hash::make($req['password']),
            'role' => 3
        ]);
        return redirect('/user')->with('success', 'user Added Successfully!');
    }
    
    public function edituser($id){
        $user = User::find($id);
        if(is_null($user)){
            return redirect('/user');
        }else{
            $data = compact('user');
           return view('user/edit')->with($data);
        }
    }
    
     public function updateuser($id, Request $req){
        $user = User::find($id);
        $req->validate(
            [
                'name' => 'required',
                'email' => 'required|email',
            ]
        );
        $user->name = $req['name'];
        $user->email = $req['email'];
        $user->phone = $req['phone'];
        $user ->save();
        return redirect('/user')->with('success', 'User Type Updated Successfully!');
    }
}
