<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AreaModel;


class StateController extends Controller
{
    public function index($id){
        $state = AreaModel::where('parent_id', $id)->get();
        $countryId = $id;
        $data = compact('state', 'countryId');
        return view('state/index')->with($data);
    }
    
     public function addState($id, Request $req){
        $countryId = $id;
        $data = compact('countryId');
        return view('state/add')->with($data);
    }
     
    public function stateCreate($id, Request $req){
        $req->validate(
            [
                'name' => 'required',
            ]
        ); 
        
        $state = new AreaModel; 
        $state->parent_id = $id;
        $state->name = $req['name'];
        $state->save();

        return redirect('/state/'.$id)->with('success', 'state Added Successfully!');
    }
    
    public function editstate($id){
        $state = AreaModel::find($id);
        if(is_null($state)){
            return redirect('/state/'.$state->parent_id);
        }else{
            $data = compact('state');
           return view('state/edit')->with($data);
        }
    }
    
     public function updatestate($id, Request $req){
        $state = AreaModel::find($id);
        $req->validate(
            [
                'name' => 'required',
            ]
        );
        $state->name = $req['name'];
        $state ->save();
        return redirect('/state/'.$state->parent_id)->with('success', 'state Updated Successfully!');
    }
    
}


