<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PartiesModel;
use App\Models\AreaModel;
use App\Models\AcChartModel;

class PartiesController extends Controller
{
   public function index(){
        $party = PartiesModel::all();
        $data = compact('party');
        return view('party/index')->with($data);
    }
    
    public function addParty(Request $req){
        $country = AreaModel::whereNull('parent_id')->get();
        $data = compact('country');
        return view('party/add')->with($data);
    }
     
    public function partyCreate(Request $req){
        $userId = $req->session()->get('userId');
        $company_id = $req->session()->get('company_id');
        $req->validate(
            [
                'name' => 'required',
                // 'email' => 'required',
                // 'phone' => 'required',
                // 'city_id' => 'required',
                'state_id' => 'required',
                'country_id' => 'required',
                'party_type' => 'required',
            ]
        ); 
        if($req['party_type'] == 0){
            $acChartModel = AcChartModel::where(array('company_id' => $company_id, 'name' => 'Sundry Debtors'))->first();
        }else{
            $acChartModel = AcChartModel::where(array('company_id' => $company_id, 'name' => 'Sundry Creditors'))->first();
        }
        $acChart = new AcChartModel; 
        $acChart->company_id = $company_id;
        $acChart->parent_id = $acChartModel->ac_chart_id;
        $acChart->name = $req['name'];
        $acChart->memo = $req['name'];
        $acChart->status = 1;
        $acChart->save();
        $acChart_id = $acChart->getKey();
        
        $party = new PartiesModel; 
        $party->ac_chart_id = $acChart_id;
        $party->name = $req['name'];
        $party->email = $req['email'];
        $party->phone = $req['phone'];
        $party->address = $req['address'];
        $party->city_id = $req['city_id'];
        $party->state_id = $req['state_id'];
        $party->country_id = $req['country_id'];
        $party->gst = $req['gst'];
        $party->pancard = $req['pancard'];
        $party->credit_limit = $req['credit_limit'];
        $party->party_type = $req['party_type'];
        $party->status = 1;
        $party->createdBy = $userId;
        $party->modifiedBy = $userId;
        $party->save();
        

        return redirect('/party')->with('success', 'Party Added Successfully!');
    }
    
    public function editParty($id){
        $party = PartiesModel::find($id);
        $country = AreaModel::whereNull('parent_id')->get();
        if(is_null($party)){
            return redirect('/party');
        }else{
            $data = compact('party', 'country');
           return view('party/edit')->with($data);
        }
    }
    
     public function updateParty($id, Request $req){
        $party = PartiesModel::find($id);
        $userId = $req->session()->get('userId');
        $req->validate(
            [
                'name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'city_id' => 'required',
                'state_id' => 'required',
                'country_id' => 'required',
            ]
        ); 
        $party->name = $req['name'];
        $party->email = $req['email'];
        $party->phone = $req['phone'];
        $party->address = $req['address'];
        $party->city_id = $req['city_id'];
        $party->state_id = $req['state_id'];
        $party->country_id = $req['country_id'];
        $party->gst = $req['gst'];
        $party->pancard = $req['pancard'];
        $party->credit_limit = $req['credit_limit'];
        $party->party_type = $req['party_type'];
        $party->createdBy = $userId;
        $party->modifiedBy = $userId;
        $party->save();

        return redirect('/party')->with('success', 'Parties Updated Successfully!');
    }
    
   public function partyDetails(){
        return view('party/partyDetails');
    }
}
