<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\itemsModel;
use App\Models\MasterDetailsModel;

class ItemsController extends Controller
{
    
   public function index(){
        $item = itemsModel::all();
        $data = compact('item');    
        return view('item/index')->with($data);
    }
    
    public function addItem(Request $req){
        return view('item/add');
    }
     
    public function itemCreate(Request $req){
        $userId = $req->session()->get('userId');
        $company_id = $req->session()->get('company_id');
        $req->validate(
            [
                'name' => 'required',
                'item_code' => 'required',
                'cost_price' => 'required',
                'sale_price' => 'required',
                'gst' => 'required',
            ]
        ); 
        
        $item = new itemsModel; 
        $item->company_id = $company_id;
        $item->name = $req['name'];
        $item->item_code = $req['item_code'];
        $item->cost_price = $req['cost_price'];
        $item->sale_price = $req['sale_price'];
        $item->description = $req['description'];
        $item->opening_stock_value = $req['opening_stock_value'];
        $item->unit_id = $req['unit_id'];
        $item->gst = $req['gst'];
        $item->hsnCode = $req['hsnCode'];
        $item->status = 1;
        $item->save();

        return redirect('/item')->with('success', 'item Added Successfully!');
    }
    
    public function editItem($id){
        $item = itemsModel::find($id);
        if(is_null($item)){
            return redirect('/item');
        }else{
            $data = compact('item');
           return view('item/edit')->with($data);
        }
    }
    
    public function updateItem($id, Request $req){
        $item = itemsModel::find($id);
        $userId = $req->session()->get('userId');
        $company_id = $req->session()->get('company_id');
        $req->validate(
            [
                'name' => 'required',
                'item_code' => 'required',
                'cost_price' => 'required',
                'sale_price' => 'required',
                'gst' => 'required',
            ]
        ); 
        
        $item->company_id = $company_id;
        $item->name = $req['name'];
        $item->item_code = $req['item_code'];
        $item->cost_price = $req['cost_price'];
        $item->sale_price = $req['sale_price'];
        $item->description = $req['description'];
        $item->opening_stock_value = $req['opening_stock_value'];
        $item->unit_id = $req['unit_id'];
        $item->gst = $req['gst'];
        $item->hsnCode = $req['hsnCode'];
        $item->status = 1;
        $item->save();

        return redirect('/item')->with('success', 'Parties Updated Successfully!');
    }
    
    public function adjustStock(Request $req){
        $company_id = $req->session()->get('company_id');
        date_default_timezone_set('Asia/Kolkata');
        $date = date('Y-m-d H:i:s');
        $item = itemsModel::find($req['item_id']);
        $credit = 0;
        $debit = 0;
        if($req->manage_stock == 'credit'){
            $credit = $req['quantity'];
        }else{
            $debit = $req['quantity'];
        }
        $total_price = $item->cost_price*$req['quantity'];
        $gst = $total_price*($item->gst/100);
        $masterDetails = new MasterDetailsModel; 
        $masterDetails->company_id = $company_id;
        $masterDetails->item_id = $req['item_id'];
        $masterDetails->credit = $credit;
        $masterDetails->debit = $debit;
        $masterDetails->per_item_price = $item->cost_price;
        $masterDetails->total_price = $total_price;
        $masterDetails->gst = $gst;
        $masterDetails->total_with_gst = $total_price+$gst;
        $masterDetails->date = $date;
        $masterDetails->save();
        
        return redirect('/item')->with('success', 'Stock Updated Successfully!');
    }
    
}
