<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CompanyModel;
use App\Models\AreaModel;
use App\Models\AcDefaultChartModel;
use App\Models\AcChartModel;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class CompanyController extends Controller
{
   
    public function index(){
        $company = CompanyModel::all();
        $data = compact('company');
        return view('company/index')->with($data);
    }
    
    public function addCompany(Request $req){
        $country = AreaModel::whereNull('parent_id')->get();
        $data = compact('country');
        return view('company/add')->with($data);
    }
     
    public function companyCreate(Request $req){
        $req->validate(
            [
                'name' => 'required',
                'contact_person_name' => 'required',
                'city_id' => 'required',
                'state_id' => 'required',
                'country_id' => 'required',
                'phone' => 'required|digits:10',
                'email' => 'required|email|unique:users,email',
            ]
        ); 
        // code Check
        $code = rand ( 0000 , 9999 );
        $code = 'AC'.$code;
        $checkCompanyCode = CompanyModel::where('code', $code)->first();
        while(!empty($checkCompanyCode)) {
            $code = rand ( 0000 , 9999 );
            $code = 'AC'.$code;
            $checkCompanyCode = CompanyModel::where('code', $code)->first();
        }
        if(!empty($req->file('logo'))){
            $logo = $req->file('logo')->store('logo');
            if($file = $req->hasFile('logo')) {
                $file = $req->file('logo') ;
                $fileName = $file->getClientOriginalName() ;
                $destinationPath = public_path().'/logo' ;
                $file->move($destinationPath,$fileName);
            }else{
                $fileName = '';
            }
        }else{
            $fileName = '';
        }


        $company = new CompanyModel; 
        $company->code = $code;
        $company->name = $req['name'];
        $company->address = $req['address'];
        $company->city_id = $req['city_id'];
        $company->state_id = $req['state_id'];
        $company->country_id = $req['country_id'];
        $company->gstNo = $req['gstNo'];
        $company->pancard = $req['pancard'];
        $company->zip_code = $req['zip_code'];
        $company->phone = $req['phone'];
        $company->email = $req['email'];
        $company->contact_person_name = $req['contact_person_name'];
        $company->logo = $fileName;
        $company->starting_year = $req['starting_year'];
        $company->ending_year = $req['ending_year'];
        $company->status = 1;
        $company->save();
        $companyId = $company->getKey();
        
        User::create([
            'company_id' => $companyId,
            'name' => $req['contact_person_name'],
            'email' => $req['email'],
            'password' => Hash::make('123123'),
            'role' => 2
        ]);
        
        $acDefaultChart = AcDefaultChartModel::all();
        foreach($acDefaultChart as $adc){
            $acChart = new AcChartModel; 
            $acChart->company_id = $companyId;
            $acChart->parent_id = $adc->parent_id;
            $acChart->code = $adc->code;
            $acChart->name = $adc->name;
            $acChart->memo = $adc->memo;
            $acChart->status = 1;
            $acChart->save();
        }

        return redirect('/company')->with('success', 'Company Added Successfully!');
    }
    
    public function editCompany($id){
        $company = CompanyModel::find($id);
        $country = AreaModel::whereNull('parent_id')->get();
        $state = AreaModel::where('parent_id', $company['country_id'])->get();
        $city = AreaModel::where('parent_id', $company['state_id'])->get();
        if(is_null($company)){
            return redirect('/company');
        }else{
            $data = compact('company', 'country', 'state', 'city');
           return view('company/edit')->with($data);
        }
    }
    
    public function updateCompany($id, Request $req){
        $company = CompanyModel::find($id);
        $req->validate(
            [
                'name' => 'required',
                'contact_person_name' => 'required',
                'city_id' => 'required',
                'state_id' => 'required',
                'country_id' => 'required',
                'phone' => 'required|digits:10',
                'email' => 'required|email',
            ]
        ); 
        if(!empty($req->file('logo'))){
            $logo = $req->file('logo')->store('logo');
            if($file = $req->hasFile('logo')) {
                $file = $req->file('logo') ;
                $fileName = $file->getClientOriginalName() ;
                $destinationPath = public_path().'/logo' ;
                $file->move($destinationPath,$fileName);
            }else{
                $fileName = $company->logo;
            }
        }else{
            $fileName = $company->logo;
        }

        $user = User::where('company_id', $id)->first();
        if ($user) {
            $user->name = $req['contact_person_name'];
            $user->email = $req['email'];
            $user->save();
        }
        $company = new CompanyModel; 
        $company->code = $company->code;
        $company->name = $req['name'];
        $company->address = $req['address'];
        $company->city_id = $req['city_id'];
        $company->state_id = $req['state_id'];
        $company->country_id = $req['country_id'];
        $company->gstNo = $req['gstNo'];
        $company->pancard = $req['pancard'];
        $company->zip_code = $req['zip_code'];
        $company->phone = $req['phone'];
        $company->email = $req['email'];
        $company->contact_person_name = $req['contact_person_name'];
        $company->logo = $fileName;
        $company->starting_year = $req['starting_year'];
        $company->ending_year = $req['ending_year'];
        $company->status = 1;
        $company->save();
        return redirect('/company')->with('success', 'User Type Updated Successfully!');
    }
    
    public function profile(){
        $company = CompanyModel::all();
        $data = compact('company');
        return view('company/profile')->with($data);
    }
}
