<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BankDetailsModel;
use App\Models\UserModel;
use App\Models\AcChartModel;

class BankDetailsController extends Controller
{
    public function index(Request $req){ 
        $userId = $req->session()->get('company_id');
        $bankDetails = BankDetailsModel::where('company_id', $userId)->with('user')->get();
        $data = compact('bankDetails');
        return view('bankDetails/index')->with($data);
    }
    
    public function add(){
        return view('bankDetails/add');
    }
    
    public function bankCreate(Request $req){
        $company_id = $req->session()->get('company_id');
        $req->validate(
            [
                'account_type' => 'required',
            ]
        ); 
        
        $acChartModel = AcChartModel::where(array('company_id' => $company_id, 'name' => 'Bank Accounts'))->first();
        
        $acChart = new AcChartModel; 
        $acChart->company_id = $company_id;
        $acChart->parent_id = $acChartModel->ac_chart_id;
        $acChart->name = $req['name'];
        $acChart->memo = $req['name'];
        $acChart->status = 1;
        $acChart->save();
        $acChart_id = $acChart->getKey();
        
        $bank = new BankDetailsModel; 
        $bank->ac_chart_id = $acChart_id;
        $bank->company_id = $company_id;
        $bank->account_type = $req['account_type'];
        $bank->name = $req['name']??'';
        $bank->account_no = $req['account_no']??'';
        $bank->ifsc_code = $req['ifsc_code']??'';
        $bank->bank_branch = $req['bank_branch']??'';
        $bank->account_holder_name = $req['account_holder_name']??'';
        $bank->upi_id = $req['upi_id']??'';
        $bank->save();

        return redirect('/bankDetails')->with('success', 'Bank Details Added Successfully!');
    }
    
    public function edit($id){
        $bankDetails = BankDetailsModel::find($id);
        // echo "<pre>";
        // print_r($bankDetails);
        // die;
        if(is_null($bankDetails)){
            return redirect('/bankDetails');
        }else{
            $data = compact('bankDetails');
            return view('bankDetails/edit')->with($data);
        }
    }
    
    public function updateBank($id, Request $req){
        $bankDetails = BankDetailsModel::find($id);
        $company_id = $req->session()->get('company_id');
        $req->validate(
            [
                'account_type' => 'required',
            ]
        ); 
        
        $bank->company_id = $company_id;
        $bank->account_type = $req['account_type'];
        $bank->name = $req['name']??'';
        $bank->account_no = $req['account_no']??'';
        $bank->ifsc_code = $req['ifsc_code']??'';
        $bank->bank_branch = $req['bank_branch']??'';
        $bank->account_holder_name = $req['account_holder_name']??'';
        $bank->upi_id = $req['upi_id']??'';
        $bank->save();

        return redirect('/bankDetails')->with('success', 'Bank Details Updated Successfully!');
    }
    
    public function ajaxOfBankDetails(Request $req){
        $company_id = $req->session()->get('company_id');
        $bank = BankDetailsModel::where('company_id', $company_id)->get();
        $str ='<label for="payment_received_in"> Payment Received In</label>';
        $str .= '<select name="bank_id" class="form-select" id="bank_id">';
        $str .= '<option value="">Select Bank</option>';
        foreach($bank as $b){
            $str .= '<option value="'.$b->ac_chart_id.'">'.$b->name.'</option>';
        }
        $str .= '</select>';
        
        echo $str;
    }
}
